<?php

// example usage
// ==================
/*
	// get dealer
	$dealer_id = 30;
	$afd = new AF_dealers($dbconn);
	$flds = $afd->get($dealer_id);

	// insert new dealer
	$afd = new AF_dealers($dbconn);
	$afd->set_assoc($_POST['flds']);
	if(!$afd->save())
	{
		print_r($afd->error);
		exit();
	}

	// insert/update dealer
	$afd = new AF_dealers($dbconn);
	$afd->set('dealer_id',$id);
	$afd->set('name',$val);
	$afd->set_assoc($_POST['flds']);
	if(!$afd->save())
	{
		print_r($afd->error);
		exit();
	}

	// delete dealer
	$dealer_id = 30;
	$afd = new AF_dealers($dbconn);
	$flds = $afd->delete($dealer_id);
	
*/

class AF_dealers
{
	var $dbconn   = null;
	var $flds     = array();
	var $error    = array();
	
	function AF_dealers($dbconn)
	{
		$this->init_flds();
		$this->dbconn = $dbconn;
	}

	function init_flds()
	{
		$this->flds["dealer_id"] = "";
		$this->flds["d_type"]    = "";
		$this->flds["name"]      = "";
		$this->flds["address"]   = "";
		$this->flds["address2"]  = "";
		$this->flds["city"]      = "";
		$this->flds["state"]     = "";
		$this->flds["zip"]       = "";
		$this->flds["country"]   = "";
		$this->flds["phone"]     = "";
	}

	function get($id)
	{
		if(is_numeric($id))
		{
			$id = mysql_real_escape_string(strtolower($id));
			$query = "select * from dealers where `dealer_id` = '$id' LIMIT 1 ";
  			$result = mysql_query($query, $this->dbconn); 
			if(mysql_num_rows($result)==1)
			{
				$row = mysql_fetch_assoc($result);
				$this->set_assoc($row);
			}
		}

		return $this->flds;
	}

	function set($fld,$val)
	{
		if(isset($this->flds[$fld]))
			$this->flds[$fld] = stripslashes(trim($val));
		else
			$this->error[] = "$fld is not a valid field";	
		return;
	}
	
	function set_assoc($flds)
	{
		if(is_array($flds))
		{
			foreach($flds as $key=>$val)
				$this->set($key,$val);	
		}
		else
			$this->error[] = "Set_assoc() array not passed.";	
		return;
	}
	
	function is_valid()
	{
		if( $this->flds["d_type"]!='D' && $this->flds["d_type"]!='W')
			$this->error[] = "Dealer type is required.";
			
		if($this->flds["name"]=="")
			$this->error[] = "Dealer name is required.";
		
		if($this->flds["address"]=="")
			$this->error[] = "Address is required.";

		if($this->flds["city"]=="")
			$this->error[] = "City is required.";
		
		if($this->flds["state"]=="" && $this->flds["country"]=='USA')
			$this->error[] = "State is required.";

		if(strlen($this->flds["zip"])!=5 && $this->flds["country"]=='USA')
			$this->error[] = "A 5 digit zip is required.";
		
		if( strlen($this->flds["country"])!=3 )
			$this->error[] = "Country is required.";

		return (count($this->error)==0)? true : false ;
	}

	function save($id=0)
	{
		if($this->is_valid())
		{
			$dealer_id = mysql_real_escape_string($this->flds["dealer_id"]);
			$d_type    = mysql_real_escape_string($this->flds["d_type"]);
			$name      = mysql_real_escape_string($this->flds["name"]);
			$address   = mysql_real_escape_string($this->flds["address"]);
			$address2  = mysql_real_escape_string($this->flds["address2"]);
			$city      = mysql_real_escape_string($this->flds["city"]);
			$state     = mysql_real_escape_string($this->flds["state"]);
			$zip       = mysql_real_escape_string($this->flds["zip"]);
			$country   = mysql_real_escape_string($this->flds["country"]);
			$phone     = mysql_real_escape_string($this->flds["phone"]);
			
			$id = mysql_real_escape_string($id);
			$query = "select 1 from `dealers` where `dealer_id` = $id ";
  			$trows = 0;
  			$result=mysql_query($query, $this->dbconn);
  			if( $result )
				  $trows = mysql_num_rows($result);

			if( $trows == 1 ) // update
			{
				$query = "UPDATE `dealers` set `d_type`='$d_type',`name`='$name',`address`='$address',`address2`='$address2',`city`='$city', 
				          `state`='$state',`country`='$country',`zip`='$zip',`phone`='$phone' 
                          WHERE `dealer_id`=$id ";
			}
			else // insert
			{
				$query = "INSERT INTO `dealers` (`d_type`,`name`,`address`,`address2`,`city`,`state`,`zip`,`country`,`phone`) 
				          VALUES ('$d_type','$name','$address','$address2','$city','$state','$zip','$country','$phone')";
			}
			return mysql_query($query, $this->dbconn);// or die($query.": ".mysql_error());
		}
		return false;
	}

	function delete($id)
	{
		if(is_numeric($id))
		{
			$id = mysql_real_escape_string($id);
			$query = "delete from `dealers` where `dealer_id`=$id LIMIT 1";
  			return mysql_query($query, $this->dbconn); 
		}
		return false;
	}
}

?>