<?php

  function make_thumb($img_src, $img_dest, $width, $height) {
    if (!($image_info = @getimagesize($img_src))) {
			trigger_error("ERROR: Image source <B>$img_src</B> does not appear to be an image ");
		} // if
		else {
			exec("/usr/local/bin/convert +profile \"*\" -geometry $width" . "x$height -quality 75 \"$img_src\" \"$img_dest\"");
			$imageinfo = getimagesize($img_dest);
    } // else 
  } // if

	function make_qs_vars($exception = "") 
	{
		// this function creates an HTML string of the _GET variables.
		// the $exception will be left out of the list, optional.
		$output = "";
		$global_ignore = array("dodelete","delete","todelete"); // always ignore these values...
		if (is_array($_POST) or is_array($_GET)) // if there are actually $_POST or $_GET variables...
		{ 
			$var_array = array_merge($_POST,$_GET); // copy the array of _POST variables
			$var_array = array_unique($var_array);
			if (is_array($exception)) // remove the exception, if any...
			{
				foreach($exception as $key=>$val) 
				{
					unset($var_array[$val]);
				}
			}
			else if ($exception!="") 
				unset($var_array[$exception]);
	
			// remove gloabal ignore values...
			foreach($global_ignore as $key=>$val)
			{
				unset($var_array[$val]);
			} 
			$var_array = array_unique($var_array);
			unset($var_array[""]);
			foreach($var_array as $key=>$val)
			{
				if ($val!="" && $key!="") 
					$output .= "&$key=" . urlencode(trim($val));
			}
		}
		return($output);
	}
	
	function make_pages( $total_pgs, $this_pg )
	{
		$html           = "";
		$show_pg_links  = 10;
		$pg_to_start    = 1;
		$url            = $_SERVER["PHP_SELF"];
		
		if( $total_pgs>1 )
		{
			// move to first page
			if( $this_pg > $show_pg_links )  
				$html .= "<a href=\"$url?pg=1".make_qs_vars("pg")."\">&lt;&lt;</a>&nbsp;|&nbsp;";

			// determine which page to begin rendering links
			$block       = ceil($this_pg/$show_pg_links)-1;
			$pg_to_start = ($block * $show_pg_links)+1;

			// move to previous set of page links
			if ( $this_pg > 1 )
				$html .= "<a href=\"$url?pg=".($this_pg-1).make_qs_vars("pg") ."\">&lt;</a>&nbsp;|&nbsp;";
				
			// move page links
			for($i=0; $i<$show_pg_links; $i++)
			{
				$newPageNum = $pg_to_start + $i;
				if( $newPageNum > $total_pgs )
					break;
	
				$html .= ( $i > 0 )? "&nbsp;&nbsp;" : "" ;
				$html .= "<a href=\"$url?pg=".$newPageNum.make_qs_vars("pg") ."\">"; 
				$html .= ( $this_pg == $newPageNum )? "<b><u>$newPageNum</u></b></a>" : "$newPageNum</a>" ;
			}

			// move to next set of page links
			if( $this_pg < $total_pgs)
				$html .= "&nbsp;|&nbsp;<a href=\"$url?pg=".($this_pg+1).make_qs_vars("pg") ."\">&gt;</a>";
		
			// move to last page
			if( $this_pg < $total_pgs )
				$html .= "&nbsp;|&nbsp;<a href=\"$url?pg=".$total_pgs.make_qs_vars("pg") ."\">&gt;&gt;</a>";
		
		}
		return $html;
	}
?>